<?php
require 'rb.php';
R::setup('sqlite:mwalimu.db');

try {
    // Remove all existing schools (drops all rows, not table)
    R::wipe('school');

    // Add sample schools
    $schools = [
        ['school_name' => 'Sample High School', 'school_email' => 'sample@high.edu'],
        ['school_name' => 'Example Academy', 'school_email' => 'example@academy.org'],
        ['school_name' => 'Test College', 'school_email' => 'test@college.com']
    ];

    foreach ($schools as $schoolData) {
        $school = R::dispense('school');
        $school->school_name = $schoolData['school_name'];
        $school->school_email = $schoolData['school_email'];
        R::store($school);
    }

    echo "Table 'school' created/cleaned and populated successfully!";
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
