<?php
// create_test_school.php

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include RedBeanPHP
require 'rb.php';

// Setup SQLite database (match your existing setup)
R::setup('sqlite:mwalimu.db');
R::freeze(false);

// Set the school details
$school_email = 'info@school.com';
$school_password = 'Kenya@254';

// Check if school already exists
$existing_school = R::findOne('school', 'email = ?', [$school_email]);

if ($existing_school) {
    echo "School with email {$school_email} already exists.<br>";

    // Set session variables for the existing school
    $_SESSION['school_id'] = $existing_school->id;
    $_SESSION['school_name'] = $existing_school->name;

    // Create cookies from session variables
    setcookie('school_id', $_SESSION['school_id'], time() + 86400, "/"); // Cookie expires in 1 day
    setcookie('school_name', $_SESSION['school_name'], time() + 86400, "/"); // Cookie expires in 1 day

    echo "Cookies set for existing school.<br>";
} else {
    // Create a new school bean
    $school = R::dispense('school');
    $school->name = 'Test School';
    $school->email = $school_email;

    // Hash the password securely
    $school->password = password_hash($school_password, PASSWORD_DEFAULT);
    $school->phone_number = '0700000000';
    $school->address = 'P.O Box 12345 Nairobi';
    $school->status = 'active'; // Set the status to active
    $school->subscription_expiry = null;

    // Store the school in the database
    $id = R::store($school);

    if ($id) {
        echo "Test school created successfully with ID: {$id}<br>";

        // Set session variables for the new school
        $_SESSION['school_id'] = $id;
        $_SESSION['school_name'] = $school->name;

        // Create cookies from session variables
        setcookie('school_id', $_SESSION['school_id'], time() + 86400, "/"); // Cookie expires in 1 day
        setcookie('school_name', $_SESSION['school_name'], time() + 86400, "/"); // Cookie expires in 1 day

        echo "Cookies set for new school.<br>";
    } else {
        echo "Failed to create test school.<br>";
    }
}

// Check if session variables exist before accessing them
if (isset($_SESSION['school_id'])) {
    echo "School ID: " . htmlspecialchars($_SESSION['school_id']) . "<br>";
} else {
    echo "School ID is not set.<br>";
}

if (isset($_SESSION['school_name'])) {
    echo "School Name: " . htmlspecialchars($_SESSION['school_name']) . "<br>";
} else {
    echo "School Name is not set.<br>";
}

// Provide login link
echo "<br><a href='/index.php?action=school_login'>Login to School Dashboard</a>";
?>

<!DOCTYPE html>
<html>
<body>
<h2>Cookie Display</h2>
<?php
// Display all cookies
echo "<h3>Cookies:</h3>";
if (count($_COOKIE) > 0) {
    foreach ($_COOKIE as $key => $value) {
        echo htmlspecialchars($key) . ": " . htmlspecialchars($value) . "<br>";
    }
} else {
    echo "No cookies are set.";
}
?>
</body>
</html>
