<?php
// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ob_start(); //Kesh start output buffering

// Set the custom session save path before session_start()
ini_set('session.save_path', './mwalimu_sessions');

// Start session here
session_start();

// Handle logout action
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    session_destroy();
    header('Location: index.php?action=landing');
    exit();
}

// Include RedBeanPHP and shared files
require 'rb.php';
require 'header.php';

// Setup SQLite database
R::setup('sqlite:mwalimu.db');
R::freeze(false);

// Define the action parameter to determine the route
$action = $_GET['action'] ?? 'landing';

// Map actions to corresponding files in the "views" folder
$routes = [
    'landing' => 'views/landing.php',
    'teacher_login' => 'views/teacher_login.php',
    'teacher_register' => 'views/teacher_register.php',
    'teacher_update' => 'views/teacher_update.php',
    'teacher_dashboard' => 'views/teacher_dashboard.php',
    'teacher_job_search' => 'views/teacher_job_search.php',
    'teacher_profile' => 'views/teacher_profile.php',
    'teacher_job_apply' => 'views/teacher_job_apply.php',
    'school_login' => 'views/school_login.php',
    'school_register' => 'views/school_register.php',
    'school_dashboard' => 'views/school_dashboard.php',
    'school_post_job' => 'views/school_post_job.php',
    'school_search_candidate' => 'views/school_search_candidate.php',
    'admin_login' => 'views/admin_login.php',
    'admin_dashboard' => 'views/admin_dashboard.php',
    'pay_subscription' => 'views/pay_subscription.php', // Add pay_subscription route
    'subscription_callback' => 'views/subscription_callback.php' // Add subscription_callback route
];

// Check if the requested action exists in the routes array
if (array_key_exists($action, $routes)) {
    include $routes[$action]; // Include the specific page content
} else {
    // If route is not found, show a 404 error page
    echo "<div class='w3-container w3-deep-orange'><h1>404 - Page Not Found</h1></div>";
}

require 'footer.php'; // Include footer at the end of every page
ob_end_flush(); // Send the buffered content to the browser
?>
