<style>
/* Navigation Bar */
.nav {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1em;
    background-color: #004d00; /* Deep Green */
    color: white;
    position: relative;
}

/* Logo & Motto */
.logo-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    line-height: 1.1; /* Reduce spacing */
}

.logo {
    font-family: "IM Fell English", serif;
    font-size: 40px;
    font-weight: bold;
}

.motto {
    font-family: "IM Fell English", serif;
    font-style: italic;
    font-size: 14px;
    color: #feffca;
    margin-top: -5px; /* Pulls it closer */
}
/* Logo Container */
.logo-container i {
    color: white; /* Or any color you prefer */
    font-size: 40px; /* Adjust size to match text */
    margin-right: 5px; /* Space between icon and text */
    vertical-align: middle;
}

/* Menu Links */
.menu-links {
    list-style: none;
    padding: 0;
    margin: 0;
    display: flex;
    background: #004d00;
    justify-content: space-around;
    align-items: center;
}

.menu-links li {
    padding: 10px;
}

.menu-links a {
    text-decoration: none;
    color: white;
    font-size: 18px;
    font-weight: bold;
    padding: 12px 20px;
    border-radius: 5px;
    transition: 0.3s;
    display: flex;
    align-items: center;
    gap: 5px;
}

/* Hover & Active Effects */
.menu-links a:hover {
    background: #feffca;
    color: #000;
}

.menu-links a.active {
    background: #ffcc00;
    color: #000;
    border-bottom: 3px solid #fff;
}

/* Mobile Menu */
.menu-icon {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
}

.menu-icon span {
    display: block;
    width: 25px;
    height: 3px;
    background: white;
    transition: 0.3s;
}

#menu-btn {
    display: none;
}

/* Mobile Responsive */
@media (max-width: 768px) {
    .menu-links {
        display: none;
        flex-direction: column;
        width: 100%;
        position: absolute;
        top: 60px;
        left: 0;
        background: #004d00;
    }

    .menu-links li {
        text-align: center;
        width: 100%;
        padding: 10px 0;
    }

    .menu-icon {
        display: flex;
    }

    #menu-btn:checked ~ .menu-links {
        display: flex;
    }
}
</style>

<nav class="nav">
  <div class="logo-container">
    <div>
        <i class="fas fa-chalkboard-teacher"></i> 
        <span class="logo">Mwalimu</span>♥<span>Link<sup>&trade;</sup></span>
    </div>
    <span class="motto">[ Creating Opportunities ]</span>
</div>

    <input type="checkbox" id="menu-btn">
    <label for="menu-btn" class="menu-icon">
        <span></span>
        <span></span>
        <span></span>
    </label>

    <ul class="menu-links">
        <li><a href="index.php?action=landing"><i class="fas fa-home"></i> Home</a></li>
        <li><a href="index.php?action=teacher_register"><i class="fas fa-user-plus"></i> Teacher Register</a></li>
        <li><a href="index.php?action=teacher_login"><i class="fas fa-user"></i> Teacher Login</a></li>
        <li><a href="index.php?action=school_register"><i class="fas fa-school"></i> School Register</a></li>
        <li><a href="index.php?action=school_login"><i class="fas fa-lock"></i> School Login</a></li>
        <li><a href="index.php?action=admin_login"><i class="fas fa-user-shield"></i> Admin Login</a></li>
    </ul>
</nav>