<?php
// admin_dashboard.php

// Check if admin is logged in
if (!isset($_COOKIE['admin_id'])) {
    header('Location: index.php?action=admin_login');
    exit();
}

// Handle logout functionality
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    setcookie('admin_id', '', time() - 3600, "/"); // Delete the cookie
    header('Location: index.php?action=landing');
    exit();
}

// Admin dashboard content starts here
?>

<article class="card" style="max-width: 80%; margin: 2rem auto;">
    <header>
        <h2 style="text-align: center;">Admin Dashboard</h2>
    </header>

    <div style="padding: 1rem;">
        <h3>Manage Tables</h3>
        <nav>
            <ul>
                <li><a href="?action=view_schools" role="button" class="secondary">View Schools</a></li>
                <li><a href="?action=view_teachers" role="button" class="secondary">View Teachers</a></li>
                <li><a href="?action=view_jobs" role="button" class="secondary">View Jobs</a></li>
            </ul>
        </nav>

        <a href="?action=logout" role="button">Logout</a>
    </div>
</article>
