<?php
if (!isset($_SESSION['school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

$school_id = $_SESSION['school_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'];
    $description = $_POST['description'];
    $requirements = $_POST['requirements'];
    $salary = $_POST['salary'];

    $job = R::dispense('job');
    $job->school_id = $school_id;
    $job->title = $title;
    $job->description = $description;
    $job->requirements = $requirements;
    $job->salary = $salary;
    $job->posted_date = R::isoDateTime();  // Current timestamp

    R::store($job);

    echo "<div class='w3-container w3-green'><h2>Job Posted Successfully!</h2></div>";
}
?>

<div class="w3-container w3-green">
    <h2>Post a Job</h2>
    <a href="index.php?action=school_dashboard" class="w3-bar-item w3-link"><i class="fas fa-user-shield"></i>Back to Dashboard</a>
</div>

<form method="POST" action="" class="w3-container">
    <label>Job Title:</label>
    <input type="text" name="title" required class="w3-input"><br>

    <label>Job Description:</label>
    <textarea name="description" required class="w3-input"></textarea><br>

    <label>Requirements:</label>
    <textarea name="requirements" required class="w3-input"></textarea><br>

    <label>Salary:</label>
    <input type="number" name="salary" required class="w3-input"><br>

    <button type="submit" class="w3-button w3-blue">Post Job</button>
</form>
