<?php
// school_register.php;


// Configuration
$api_key = 'ISPubKey_live_40f25458-716c-47c5-b049-786fd1f3a1ce'; // Store in env variables
$base_url = 'https://mwalimulink.kenprohosting.com.com/online/index.php?school-dashboard';
$subscription_amount = 12; // KES

// Payment processing function
function process_payment($school_id, $email, $phone) {
    global $api_key, $base_url, $subscription_amount;
    
    $tracking_id = 'MWL' . uniqid() . $school_id;
    
    $payload = [
        'public_key' => $api_key,
        'amount' => $subscription_amount,
        'currency' => 'KES',
        'email' => $email,
        'phone_number' => $phone,
        'api_ref' => $tracking_id,
        'redirect_url' => $base_url . 'school_register.php'
    ];

    $ch = curl_init('https://payment.intasend.com/api/v1/checkout/');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $api_key
        ]
    ]);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return ($http_code == 201) 
        ? ['status' => 'success', 'data' => json_decode($response, true), 'tracking_id' => $tracking_id]
        : ['status' => 'error', 'message' => $response];
}

// Handle payment callback
if (isset($_GET['api_ref'])) {
    $tracking_id = $_GET['api_ref'];
    
    $ch = curl_init("https://payment.intasend.com/api/v1/checkout/$tracking_id/verify/");
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['Authorization: Bearer ' . $api_key]
    ]);
    
    $response = curl_exec($ch);
    $result = json_decode($response, true);
    curl_close($ch);

    if ($result['status'] === 'COMPLETED') {
        $school = R::findOne('school', 'tracking_id = ?', [$tracking_id]);
        if ($school) {
            $school->status = 'active';
            $school->subscription_expiry = date('Y-m-d', strtotime('+1 year'));
            R::store($school);
            $_SESSION['success'] = "Payment completed! Account activated.";
        }
    } else {
        $_SESSION['error'] = "Payment failed: " . ($result['message'] ?? 'Unknown error');
    }
    header('Location: ' . $base_url . 'school_register.php');
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $school = R::dispense('school');
        $school->name = htmlspecialchars($_POST['name']);
        $school->email = filter_var($_POST['email'], FILTER_VALIDATE_EMAIL);
        $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
        $school->address = htmlspecialchars($_POST['address']);
        $school->status = 'inactive';
        $school->subscription_expiry = null;
        
        $id = R::store($school);
        
        $payment_result = process_payment(
            $id,
            $school->email,
            preg_replace('/[^0-9]/', '', $_POST['payment_phone'])
        );

        if ($payment_result['status'] === 'success') {
            $school->tracking_id = $payment_result['tracking_id'];
            R::store($school);
            header('Location: ' . $payment_result['data']['url']);
            exit();
        }
        throw new Exception($payment_result['message'] ?? 'Payment initiation failed');
        
    } catch (Exception $e) {
        $error = "Error: " . $e->getMessage();
    }
}
?>


    <div class="w3-center w3-margin-top w3-light-grey">
        <div class="w3-card-4 w3-white" style="max-width:600px; margin:20px auto;">
            <header class="w3-container w3-green">
                <h2>School Registration</h2>
            </header>

            <div class="w3-container w3-padding-24">
                <?php if (isset($_SESSION['success'])): ?>
                    <div class="w3-panel w3-green w3-display-container">
                        <span onclick="this.parentElement.style.display='none'"
                            class="w3-button w3-large w3-display-topright">&times;</span>
                        <h3>Success!</h3>
                        <p><?= $_SESSION['success'] ?></p>
                    </div>
                    <?php unset($_SESSION['success']); ?>
                <?php endif; ?>

                <?php if (isset($_SESSION['error'])): ?>
                    <div class="w3-panel w3-red w3-display-container">
                        <span onclick="this.parentElement.style.display='none'"
                            class="w3-button w3-large w3-display-topright">&times;</span>
                        <h3>Error!</h3>
                        <p><?= $_SESSION['error'] ?></p>
                    </div>
                    <?php unset($_SESSION['error']); ?>
                <?php endif; ?>

                <?php if (isset($error)): ?>
                    <div class="w3-panel w3-red">
                        <h3>Registration Failed</h3>
                        <p><?= htmlspecialchars($error) ?></p>
                    </div>
                <?php endif; ?>

                <form method="POST" class="w3-container">
                    <div class="w3-section">
                        <label>School Name</label>
                        <input type="text" name="name" class="w3-input w3-border" required>

                        <label>Email</label>
                        <input type="email" name="email" class="w3-input w3-border" required>

                        
                        <label>Phone Number</label>
                        <input type="tel" name="phone_number" class="w3-input w3-border" 
                               pattern="2547[0-9]{8}" required>

                        <label>Address</label>
                        <input type="text" name="address" class="w3-input w3-border" required>

                        <label>M-Pesa Payment Number</label>
                        <input type="tel" name="payment_phone" class="w3-input w3-border"
                               pattern="2547[0-9]{8}" required>

                        <p class="w3-panel w3-pale-blue">
                            Subscription Fee: KES <?= number_format($subscription_amount) ?> / year
                        </p>
                        
                        <label>Password</label>
                        <input type="password" name="password" class="w3-input w3-border" required>


                        <button type="submit" class="w3-button w3-block w3-green w3-section w3-padding">
                            Register
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

