<?php
// Handle teacher registration submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT); // Hash the password
    $date_of_birth = $_POST['date_of_birth'];
    $email = $_POST['email'];
    $phone_number = $_POST['phone_number'];
    $teaching_subjects = $_POST['teaching_subjects'];
    $grade_levels = $_POST['grade_levels'];
    $years_of_experience = $_POST['years_of_experience'];

    if (isset($_POST['degrees_obtained']) && !empty($_POST['degrees_obtained'])) {
        $degrees_obtained = $_POST['degrees_obtained'];
        $institutions_attended = $_POST['institutions_attended'];
        $graduation_dates = $_POST['graduation_dates'];
    } else {
        $diploma = $_POST['diploma'];
        $diploma_institution = $_POST['diploma_institution'];
        $diploma_completion_date = $_POST['diploma_completion_date'];
    }

    $teaching_certifications = $_POST['teaching_certifications'];
    $tsc_number = $_POST['tsc_number'];

    // Handle resume upload
    $resume = $_FILES['resume'];
    $resume_name = $resume['name'];
    $resume_tmp_name = $resume['tmp_name'];
    $upload_dir = 'uploads/';

    // Ensure the upload directory exists
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0777, true);
    }

    $resume_path = $upload_dir . basename($resume_name); // Use basename to avoid path traversal

    if (move_uploaded_file($resume_tmp_name, $resume_path)) {
        // Store the data in the database
        $teacher = R::dispense('teacher');
        $teacher->name = $name;
        $teacher->password = $password; // Store the hashed password
        $teacher->date_of_birth = $date_of_birth;
        $teacher->email = $email;
        $teacher->phone_number = $phone_number;
        $teacher->teaching_subjects = $teaching_subjects;
        $teacher->grade_levels = $grade_levels;
        $teacher->years_of_experience = $years_of_experience;
        $teacher->resume = $resume_path; // Store the path to the resume

        if (isset($degrees_obtained)) {
            $teacher->degrees_obtained = $degrees_obtained;
            $teacher->institutions_attended = $institutions_attended;
            $teacher->graduation_dates = $graduation_dates;
        } else {
            $teacher->diploma = $diploma;
            $teacher->diploma_institution = $diploma_institution;
            $teacher->diploma_completion_date = $diploma_completion_date;
        }

        $teacher->teaching_certifications = $teaching_certifications;
        $teacher->tsc_number = $tsc_number;

        $id = R::store($teacher);

        // Display success message with login link
        echo "<div class='w3-container w3-green'><h2>Registration Successful!</h2>";
        echo "<p>Your account has been created. <a href='index.php?action=teacher_login'>Click here to login</a></p></div>";
    } else {
        echo "<div class='w3-container w3-red'><h2>Registration Failed!</h2>";
        echo "<p>There was an error uploading your resume. Please try again.</p></div>";
    }
}
?>

<div class="w3-container w3-green">
    <h2>Teacher Registration</h2>
</div>

<style>
    .step-form {
        background-color: #ffffff;
        margin: 20px auto;
        font-family: "Open Sans", Arial, sans-serif;
        padding: 20px;
        width: 70%;
        min-width: 300px;
        box-sizing: border-box; /* Added to ensure proper sizing */
    }

    input {
        padding: 10px;
        width: 100%;
        font-size: 17px;
        font-family: "Open Sans", Arial, sans-serif;
        border: 1px solid #aaaaaa;
        box-sizing: border-box; /* Added to ensure proper sizing */
    }

    /* Mark input boxes that gets an error on validation: */
    input.invalid {
        background-color: #ffdddd;
    }

    /* Hide all steps by default: */
    .tab {
        display: none;
    }

    button {
        background-color: #04AA6D;
        color: #ffffff;
        border: none;
        padding: 10px 20px;
        font-size: 17px;
        font-family: "Open Sans", Arial, sans-serif;
        cursor: pointer;
    }

    button:hover {
        opacity: 0.8;
    }

    #prevBtn {
        background-color: #bbbbbb;
    }

    /* Make circles that indicate the steps of the form: */
    .step {
        height: 15px;
        width: 15px;
        margin: 0 2px;
        background-color: #bbbbbb;
        border: none;
        border-radius: 50%;
        display: inline-block;
        opacity: 0.5;
    }

    .step.active {
        opacity: 1;
    }

    /* Mark the steps that are finished and valid: */
    .step.finish {
        background-color: #04AA6D;
    }
</style>

<form id="regForm" method="POST" action="" enctype="multipart/form-data" class="step-form">
    <!-- One "tab" for each step in the form: -->
    <div class="tab">
        <h4>Personal Information</h4>
        <p><input placeholder="Name..." oninput="this.className = ''" name="name" required></p>
        <p><input type="date" placeholder="Date of Birth..." oninput="this.className = ''" name="date_of_birth"
                  required></p>
        <p><input type="email" placeholder="Email..." oninput="this.className = ''" name="email" required></p>
        <p><input type="tel" placeholder="Phone Number..." oninput="this.className = ''" name="phone_number"
                  required></p>
        <p><input type="password" placeholder="Password..." oninput="this.className = ''" name="password"
                  required></p>
    </div>

    <div class="tab">
        <h4>Professional Details</h4>
        <p><input placeholder="Teaching Subjects..." oninput="this.className = ''" name="teaching_subjects" required></p>
        <p><input placeholder="Grade Levels..." oninput="this.className = ''" name="grade_levels" required></p>
        <p><input type="number" placeholder="Years of Experience..." oninput="this.className = ''"
                  name="years_of_experience" required></p>
    </div>

    <div class="tab">
        <h4>Educational Background</h4>
        <label>
            <input type="radio" name="has_degree" value="yes" checked>
            Degree(s)
        </label>
        <label>
            <input type="radio" name="has_degree" value="no">
            Diploma
        </label><br><br>

        <div id="degree_fields">
            <p><input placeholder="Degree(s) Obtained..." oninput="this.className = ''" name="degrees_obtained"></p>
            <p><input placeholder="Institution(s) Attended..." oninput="this.className = ''"
                      name="institutions_attended"></p>
            <p><input type="date" placeholder="Graduation Date(s)..." oninput="this.className = ''"
                      name="graduation_dates"></p>
        </div>

        <div id="diploma_fields" style="display: none;">
            <p><input placeholder="Diploma..." oninput="this.className = ''" name="diploma"></p>
            <p><input placeholder="Institution..." oninput="this.className = ''" name="diploma_institution"></p>
            <p><input type="date" placeholder="Completion Date..." oninput="this.className = ''"
                      name="diploma_completion_date"></p>
        </div>
    </div>

    <div class="tab">
        <h4>Certifications and Resume</h4>
        <p><input placeholder="Teaching Certification(s)..." oninput="this.className = ''"
                  name="teaching_certifications" required></p>
        <p><input placeholder="TSC Number (if applicable)..." oninput="this.className = ''" name="tsc_number"></p>
        <label>Upload Your Resume:</label>
        <input type="file" name="resume" required>
    </div>

    <div style="overflow:auto;">
        <div style="float:right;">
            <button type="button" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
            <button type="button" id="nextBtn" onclick="nextPrev(1)">Next</button>
        </div>
    </div>
    <!-- Circles which indicate the steps of the form: -->
    <div style="text-align:center;margin-top:40px;">
        <span class="step"></span>
        <span class="step"></span>
        <span class="step"></span>
        <span class="step"></span>
    </div>
</form>

<script>
    var currentTab = 0; // Current tab is set to be the first tab (0)
    showTab(currentTab); // Display the current tab

    function showTab(n) {
        var x = document.getElementsByClassName("tab");
        x[n].style.display = "block";

        if (n == 0) {
            document.getElementById("prevBtn").style.display = "none";
        } else {
            document.getElementById("prevBtn").style.display = "inline";
        }

        if (n == (x.length - 1)) {
            document.getElementById("nextBtn").innerHTML = "Submit";
        } else {
            document.getElementById("nextBtn").innerHTML = "Next";
        }

        fixStepIndicator(n)
    }

    function nextPrev(n) {
        var x = document.getElementsByClassName("tab");
        if (n == 1 && !validateForm()) return false;
        x[currentTab].style.display = "none";
        currentTab = currentTab + n;
        if (currentTab >= x.length) {
            document.getElementById("regForm").submit();
            return false;
        }
        showTab(currentTab);
    }

    function validateForm() {
        var x, y, i, valid = true;
        x = document.getElementsByClassName("tab");
        y = x[currentTab].getElementsByTagName("input");
        for (i = 0; i < y.length; i++) {
            if (y[i].hasAttribute("required") && y[i].value == "") {
                y[i].className += " invalid";
                valid = false;
            }
        }
        if (valid) {
            document.getElementsByClassName("step")[currentTab].className += " finish";
        }
        return valid;
    }

    function fixStepIndicator(n) {
        var i, x = document.getElementsByClassName("step");
        for (i = 0; i < x.length; i++) {
            x[i].className = x[i].className.replace(" active", "");
        }
        x[n].className += " active";
    }

    // JavaScript to toggle degree and diploma fields
    const degreeRadio = document.querySelector('input[name="has_degree"][value="yes"]');
    const diplomaRadio = document.querySelector('input[name="has_degree"][value="no"]');
    const degreeFields = document.getElementById('degree_fields');
    const diplomaFields = document.getElementById('diploma_fields');

    degreeRadio.addEventListener('change', () => {
        if (degreeRadio.checked) {
            degreeFields.style.display = 'block';
            diplomaFields.style.display = 'none';
        }
    });

    diplomaRadio.addEventListener('change', () => {
        if (diplomaRadio.checked) {
            degreeFields.style.display = 'none';
            diplomaFields.style.display = 'block';
        }
    });
</script>
