<?php
// Include the database connection file
//require_once 'db.php'; // Adjust the path to your database connection

// Ensure you're connected to the SQLite database
try {
    $pdo = new PDO('sqlite:./mwalimu.db'); // Ensure this path is correct
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    exit;
}

// Check for form submission to create/update a post
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $slug = $_POST['slug'] ?? '';
    $content = $_POST['content'] ?? '';
    $author_id = $_POST['author_id'] ?? 0;
    $category_id = $_POST['category_id'] ?? 0;
    $is_published = isset($_POST['is_published']) ? 1 : 0;

    if (empty($title) || empty($slug) || empty($content)) {
        echo "All fields are required!";
    } else {
        // Insert or Update the post
        try {
            $query = "INSERT INTO posts (title, slug, content, author_id, category_id, is_published, created_at, updated_at)
                      VALUES (:title, :slug, :content, :author_id, :category_id, :is_published, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)";
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':title', $title);
            $stmt->bindParam(':slug', $slug);
            $stmt->bindParam(':content', $content);
            $stmt->bindParam(':author_id', $author_id);
            $stmt->bindParam(':category_id', $category_id);
            $stmt->bindParam(':is_published', $is_published, PDO::PARAM_INT);

            $stmt->execute();
            echo "Post created successfully!";
        } catch (PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    }
}

// Retrieve all categories for dropdown
$categoriesQuery = "SELECT * FROM categories";
$categoriesStmt = $pdo->query($categoriesQuery);
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve all posts
$postsQuery = "SELECT * FROM posts ORDER BY created_at DESC";
$postsStmt = $pdo->query($postsQuery);
$posts = $postsStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Blog Admin</title>
    <!-- Add your CSS styles here -->
</head>
<body>
    <h1>Blog Admin</h1>
    
    <!-- Post Creation Form -->
    <form method="POST" action="blog_admin.php">
        <label for="title">Title:</label>
        <input type="text" name="title" id="title" required><br>

        <label for="slug">Slug:</label>
        <input type="text" name="slug" id="slug" required><br>

        <label for="content">Content:</label>
        <textarea name="content" id="content" required></textarea><br>

        <label for="author_id">Author ID:</label>
        <input type="number" name="author_id" id="author_id" required><br>

        <label for="category_id">Category:</label>
        <select name="category_id" id="category_id" required>
            <?php foreach ($categories as $category) : ?>
                <option value="<?php echo $category['id']; ?>"><?php echo $category['name']; ?></option>
            <?php endforeach; ?>
        </select><br>

        <label for="is_published">Publish:</label>
        <input type="checkbox" name="is_published" id="is_published" checked><br>

        <button type="submit">Submit Post</button>
    </form>

    <h2>All Posts</h2>
    <table>
        <thead>
            <tr>
                <th>Title</th>
                <th>Slug</th>
                <th>Category</th>
                <th>Created At</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($posts as $post) : ?>
                <tr>
                    <td><?php echo htmlspecialchars($post['title']); ?></td>
                    <td><?php echo htmlspecialchars($post['slug']); ?></td>
                    <td>
                        <?php
                        $categoryQuery = "SELECT name FROM categories WHERE id = :category_id";
                        $categoryStmt = $pdo->prepare($categoryQuery);
                        $categoryStmt->bindParam(':category_id', $post['category_id']);
                        $categoryStmt->execute();
                        $category = $categoryStmt->fetch(PDO::FETCH_ASSOC);
                        echo htmlspecialchars($category['name']);
                        ?>
                    </td>
                    <td><?php echo $post['created_at']; ?></td>
                    <td><?php echo $post['is_published'] ? 'Published' : 'Unpublished'; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>
