<?php

// Add this BEFORE any HTML output (at the top of your PHP section):
$message = $_COOKIE['message'] ?? '';
if ($message) {
    setcookie('message', '', time()-3600, '/'); // Clear cookie before HTML
}

// blog_admin.php - Admin Panel
// Authentication Check
if(!isset($_COOKIE['teacher_id'])) {
    header("Location: ?action=login");
    exit();
}

// Helper Function
function create_slug($text) {
    $text = preg_replace('/[^a-z0-9]+/', '-', strtolower($text));
    return trim($text, '-');
}

// CRUD Operations
if($_SERVER['REQUEST_METHOD'] === 'POST') { // FIXED: Changed METHOD to REQUEST_METHOD
    $id = (int)($_POST['id'] ?? 0);
    
    if(isset($_POST['delete'])) {
        $post = R::load('posts', $id);
        R::trash($post);
        setcookie('message', 'Post deleted', time()+5); // FIXED: Using cookies instead of session
    } else {
        $post = ($id > 0) ? R::load('posts', $id) : R::dispense('posts');
        
        $post->title = $_POST['title'];
        $post->slug = create_slug($_POST['title']);
        $post->content = $_POST['content'];
        $post->category_id = (int)$_POST['category_id'];
        $post->author_id = (int)$_COOKIE['teacher_id'];
        $post->is_published = isset($_POST['is_published']) ? 1 : 0;
        $post->updated_at = date('Y-m-d H:i:s');
        
        R::store($post);
        setcookie('message', 'Post ' . ($id ? 'updated' : 'created'), time()+5);
    }
    
    header("Location: ?action=blog_admin");
    exit();
}

// Fetch Data
$post = R::load('posts', (int)($_GET['id'] ?? 0));
$categories = R::find('categories');
$posts = R::find('posts', 'ORDER BY created_at DESC LIMIT 100');

// Trumbowyg WYSIWYG Editor
function include_wysiwyg() {
    echo <<<HTML
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Trumbowyg -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/trumbowyg@2.28.0/dist/ui/trumbowyg.min.css">
    <script src="https://cdn.jsdelivr.net/npm/trumbowyg@2.28.0/dist/trumbowyg.min.js"></script>
    <script>
      $('#content').trumbowyg({
        btns: [['viewHTML'], ['undo','redo'], ['strong','em','del'], 
               ['link','insertImage'], ['unorderedList','orderedList']]
      });
    </script>
    HTML;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel</title>
    <?php include_wysiwyg(); ?>
</head>
<body>
    <h1>Admin Panel</h1>
    
    <?php if(isset($_COOKIE['message'])): ?>
        <div style="background: #cfc; padding: 0.5rem; margin: 1rem 0;">
            <?= htmlspecialchars($_COOKIE['message']) ?>
            <?php setcookie('message', '', time()-3600); ?>
        </div>
    <?php endif; ?>

    <!-- Edit Form -->
    <form method="post">
        <input type="hidden" name="id" value="<?= $post->id ?>">
        
        <label>Title: 
            <input type="text" name="title" 
                   value="<?= htmlspecialchars($post->title ?? '') ?>" required> <!-- NULL check -->
        </label>
        
        <label>Category:
            <select name="category_id" required>
                <?php foreach($categories as $cat): ?>
                    <option value="<?= $cat->id ?>" <?= ($post->category_id == $cat->id) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($cat->name) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </label>
        
        <label>Publish? 
            <input type="checkbox" name="is_published" <?= $post->is_published ? 'checked' : '' ?>>
        </label>
