<?php
// blog_admin.php

//require_once '/path/to/rb.php';  // Adjust the path to your RedBeanPHP file

// Users array for authentication
$users = [
    'admin' => ['password' => 'Kenya@254', 'role' => 'admin'],
    'staff' => ['password' => 'Staff@123', 'role' => 'staff'],
];

$username = $_POST['username'] ?? $_GET['username'] ?? '';
$password = $_POST['password'] ?? $_GET['password'] ?? '';
$role = '';

// Authentication check
if (!isset($users[$username]) || $users[$username]['password'] !== $password) {
    echo <<<HTML
<form method="post">
    <h2>Login</h2>
    <label>Username: <input type="text" name="username" required></label><br>
    <label>Password: <input type="password" name="password" required></label><br>
    <button type="submit">Login</button>
</form>
HTML;
    exit();
}

$role = $users[$username]['role'];

// Slug generator
function create_slug($text) {
    $text = preg_replace('/[^a-z0-9]+/', '-', strtolower($text));
    return trim($text, '-');
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['title'], $_POST['content'])) {
    $id = (int)($_POST['id'] ?? 0);
    $message = '';

    if (isset($_POST['delete']) && $role === 'admin') {
        $post = R::load('posts', $id);
        if ($post->id) {
            R::trash($post);
            $message = 'Post deleted';
        } else {
            $message = 'Post not found';
        }
    } else {
        if ($role === 'admin' || $role === 'staff') {
            // Load the existing post or dispense a new one
            $post = ($id > 0) ? R::load('posts', $id) : R::dispense('posts');
            
            // Ensure post is a valid bean
            if ($post) {
                $post->title = $_POST['title'];
                $post->slug = create_slug($_POST['title']);
                $post->content = $_POST['content'];
                $post->author = $username;
                $post->is_published = isset($_POST['is_published']) ? 1 : 0;
                $post->updated_at = date('Y-m-d H:i:s');

                // Load and associate category if given
                $category_id = (int)($_POST['category_id'] ?? 0);
                if ($category_id > 0) {
                    $category = R::load('categories', $category_id);
                    if ($category->id) {
                        $post->category = $category;
                    } else {
                        $message = 'Category not found';
                    }
                }

                R::store($post);
                $message = 'Post ' . ($id ? 'updated' : 'created');
            } else {
                $message = 'Invalid post bean';
            }
        } else {
            $message = 'You are not allowed to post';
        }
    }
}

// Load post if ID given
$post = R::load('posts', (int)($_GET['id'] ?? 0));
$categories = R::find('categories');
$posts = R::find('posts', 'ORDER BY created_at DESC LIMIT 100');

// WYSIWYG editor
function include_wysiwyg() {
    echo <<<HTML
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/trumbowyg@2.28.0/dist/ui/trumbowyg.min.css">
<script src="https://cdn.jsdelivr.net/npm/trumbowyg@2.28.0/dist/trumbowyg.min.js"></script>
<script>
\$(function(){
    \$('#content').trumbowyg({
        btns: [['viewHTML'], ['undo','redo'], ['strong','em','del'],
        ['link','insertImage'], ['unorderedList','orderedList']]
    });
});
</script>
HTML;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Panel</title>
    <?php include_wysiwyg(); ?>
</head>
<body>
<h1>Welcome, <?= htmlspecialchars($username) ?>!</h1>
<p>Role: <?= htmlspecialchars($role) ?></p>

<?php if (!empty($message)): ?>
    <div style="background: #cfc; padding: 0.5rem; margin: 1rem 0;">
        <?= htmlspecialchars($message) ?>
    </div>
<?php endif; ?>

<!-- Post form -->
<form method="post">
    <input type="hidden" name="username" value="<?= htmlspecialchars($username) ?>">
    <input type="hidden" name="id" value="<?= $post->id ?>">

    <label>Title:
        <input type="text" name="title" value="<?= htmlspecialchars($post->title ?? '') ?>" required>
    </label><br>

    <label>Category:
        <select name="category_id" required>
            <?php foreach ($categories as $cat): ?>
                <option value="<?= $cat->id ?>" <?= ($post->category && $post->category->id == $cat->id) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($cat->name) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>

    <label>Publish?
        <input type="checkbox" name="is_published" <?= ($post->is_published ?? 0) ? 'checked' : '' ?>>
    </label><br>

    <label>Content:<br>
        <textarea id="content" name="content" rows="10" cols="80"><?= htmlspecialchars($post->content ?? '') ?></textarea>
    </label><br>

    <button type="submit">Save Post</button>

    <?php if ($post->id && $role === 'admin'): ?>
        <button type="submit" name="delete" onclick="return confirm('Delete this post?')">Delete</button>
    <?php endif; ?>
</form>

<!-- Post List -->
<h2>Recent Posts</h2>
<ul>
<?php foreach ($posts as $p): ?>
    <li>
        <strong><?= htmlspecialchars($p->title) ?></strong> - 
        <a href="?action=blog_admin&id=<?= $p->id ?>&username=<?= urlencode($username) ?>&password=<?= urlencode($password) ?>">Edit</a>
    </li>
<?php endforeach; ?>
</ul>

</body>
</html>
