<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_type = $_POST['login_type'] ?? '';

    if ($login_type === 'school') {
        try {
            // Check if email exists
            $school = R::findOne('school', 'email = ?', [$_POST['email']]);
            if (!$school) {
                throw new Exception("School does not exist.");
            }

            // Check if password matches
            if (!password_verify($_POST['password'], $school->password)) {
                throw new Exception("Incorrect password.");
            }

            // Set cookie variables
            setcookie('school_id', $school->id, time() + 3600, "/"); // expires in 1 hour
            setcookie('school_name', $school->name, time() + 3600, "/"); // expires in 1 hour

            // Redirect to school dashboard using PHP header
            header('Location: ./index.php?action=school_dashboard');
            exit();
        } catch (Exception $e) {
            $school_error_message = $e->getMessage();
        }
    } elseif ($login_type === 'teacher') {
        try {
            // Sanitize user input to prevent SQL injection or XSS attacks
            $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
            $password = $_POST['password'];

            // Find the teacher by email in the database using RedBeanPHP
            $teacher = R::findOne('teacher', 'email = ?', [$email]);

            // Verify password and handle login logic
            if ($teacher && password_verify($password, $teacher->password)) {
                // Set cookies for logged-in teacher (valid for 1 day)
                setcookie('teacher_id', $teacher->id, time() + 86400, '/', '', false, true); // httponly flag for security
                setcookie('teacher_name', $teacher->name, time() + 86400, '/', '', false, true);

                // Redirect to the teacher dashboard
                header('Location: index.php?action=teacher_dashboard');
                exit();
            } else {
                $teacher_error_message = "Invalid email or password.";
            }
        } catch (Exception $e) {
            $teacher_error_message = $e->getMessage();
        }
    }
}
?>

<article class="card" style="max-width: 80%; margin: 2rem auto;">
    <header>
        <h2 style="text-align: center;">MwalimuLink&trade;</h2>
    </header>

    <div style="display: flex; justify-content: space-around; flex-wrap: wrap;">
        <!-- School Login Card -->
        <article style="flex: 1; min-width: 300px; margin: 1rem;">
            <header>
                <h3>School Login</h3>
            </header>

            <?php if (isset($school_error_message)): ?>
                <div class="alert alert-error">
                    <h4><?php echo htmlspecialchars($school_error_message); ?></h4>
                </div>
            <?php endif; ?>

            <form method="POST">
                <input type="hidden" name="login_type" value="school">
                <div class="grid">
                    <input type="email" id="email" placeholder="Email" name="email" required>
                </div>

                <div class="grid">
                    <input type="password" placeholder="Password" id="password" name="password" required>
                </div>

                <button type="submit">Login</button>
            </form>

            <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>
        </article>

        <!-- Teacher Login Card -->
        <article style="flex: 1; min-width: 300px; margin: 1rem;">
            <header>
                <h3>Teacher Login</h3>
            </header>

            <?php if (isset($teacher_error_message)): ?>
                <div class="alert alert-error">
                    <h4><?php echo htmlspecialchars($teacher_error_message); ?></h4>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <input type="hidden" name="login_type" value="teacher">
                <div class="grid">
                    <input type="email" id="email" placeholder="Email" name="email" required>
                </div>

                <div class="grid">
                    <input type="password" placeholder="Password" id="password" name="password" required>
                </div>

                <button type="submit">Login</button>
            </form>
            <p>Don't have an account? <a href="index.php?action=teacher_register">Register here.</a></p>
        </article>
    </div>
</article>
<p>&nbsp;</p>
