<?php
// Assumes RedBeanPHP is loaded and R::setup() called in parent

$message = '';
function h($str) { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'city' => trim($_POST['city'] ?? ''),
        'country' => trim($_POST['country'] ?? ''),
        'address' => trim($_POST['address'] ?? '')
    ];

    // Validate required fields
    foreach ($data as $field => $value) {
        if (empty($value)) {
            $message = "<p style='color:red;'>Field " . ucfirst($field) . " is required.</p>";
            break;
        }
    }

    if (empty($message)) {
        $columns = implode(', ', array_keys($data));
        $placeholders = ':' . implode(', :', array_keys($data));
        $sql = "INSERT INTO international_school ($columns) VALUES ($placeholders)";

        $pdo = R::getDatabaseAdapter()->getDatabase();
        $stmt = $pdo->prepare($sql);

        foreach ($data as $key => $value) {
            $stmt->bindValue(':' . $key, $value, PDO::PARAM_STR);
        }

        if ($stmt->execute()) {
            $message = "<p style='color:green;'>School added successfully!</p>";
            $_POST = [];
        } else {
            $message = "<p style='color:red;'>Failed to save school record.</p>";
        }
    }
}
?>

<h2>Add International School</h2>
<?= $message ?>
<form method="post" style="max-width:400px;">
    <label>Name
        <input type="text" name="name" required value="<?=h($_POST['name'] ?? '')?>" />
    </label>
    <label>City
        <input type="text" name="city" required value="<?=h($_POST['city'] ?? '')?>" />
    </label>
    <label>Country
        <input type="text" name="country" required value="<?=h($_POST['country'] ?? '')?>" />
    </label>
    <label>Address
        <input type="text" name="address" required value="<?=h($_POST['address'] ?? '')?>" />
    </label>
    <button type="submit">Add School</button>
</form>

<?php
// Assumes RedBeanPHP is already set up and connected.
/**
$message = '';
function h($str) { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rec = R::dispense('international_school');
    $rec->name = trim($_POST['name'] ?? '');
    $rec->city = trim($_POST['city'] ?? '');
    $rec->country = trim($_POST['country'] ?? '');
    $rec->address = trim($_POST['address'] ?? '');

    if ($rec->name && $rec->city && $rec->country && $rec->address) {
        R::store($rec);
        $message = '<p style="color:green;">School added successfully!</p>';
    } else {
        $message = '<p style="color:red;">All fields are required.</p>';
    }
} *?
?>
<!--
<h2>Add International School</h2>
<?= $message ?>
<form method="post" style="max-width:400px;">
    <label>Name
        <input type="text" name="name" required value="<?=h($_POST['name'] ?? '')?>" />
    </label>
    <label>City
        <input type="text" name="city" required value="<?=h($_POST['city'] ?? '')?>" />
    </label>
    <label>Country
        <input type="text" name="country" required value="<?=h($_POST['country'] ?? '')?>" />
    </label>
    <label>Address
        <input type="text" name="address" required value="<?=h($_POST['address'] ?? '')?>" />
    </label>
    <button type="submit">Add School</button>
</form>
-->