<?php
// Assumes RedBeanPHP is already set up and connected.

function h($str) { return htmlspecialchars($str, ENT_QUOTES, 'UTF-8'); }

$per_page = 10;
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

$where = '';
$params = [];
if ($search !== '') {
    $where = "WHERE name LIKE ? OR city LIKE ? OR country LIKE ? OR address LIKE ?";
    $params = array_fill(0, 4, "%$search%");
}

$total = $where
    ? R::count('international_school', $where, $params)
    : R::count('international_school');
$offset = ($page - 1) * $per_page;

$records = $where
    ? R::findAll('international_school', "$where ORDER BY name LIMIT ? OFFSET ?", array_merge($params, [$per_page, $offset]))
    : R::findAll('international_school', "ORDER BY name LIMIT ? OFFSET ?", [$per_page, $offset]);

function paginate($total, $per_page, $page, $base_url) {
    $pages = max(1, ceil($total / $per_page));
    if ($pages <= 1) return;
    echo '<div>';
    if ($page > 1) {
        echo '<a href="' . h($base_url) . '&page=1">First</a> ';
        echo '<a href="' . h($base_url) . '&page=' . ($page - 1) . '">Prev</a> ';
    }
    echo "Page $page of $pages (Total: $total) ";
    if ($page < $pages) {
        echo '<a href="' . h($base_url) . '&page=' . ($page + 1) . '">Next</a> ';
        echo '<a href="' . h($base_url) . '&page=' . $pages . '">Last</a>';
    }
    echo '</div>';
}
?>

<form method="get" action="">
    <input type="hidden" name="action" value="international_school_search" />
    <input type="search" name="search" value="<?=h($search)?>" placeholder="Search name, city, country, address..." />
    <button type="submit">Search</button>
    <?php if ($search !== ''): ?>
        <a href="?action=international_school_search">Clear</a>
    <?php endif; ?>
</form>

<?php if ($total === 0): ?>
    <p>No international schools found.</p>
<?php else: ?>
    <table border="1" cellpadding="5" cellspacing="0">
        <thead>
            <tr>
                <th>Name</th><th>City</th><th>Country</th><th>Address</th><th>Locate</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($records as $rec): ?>
            <tr>
                <td><a href="?action=international_school_details&id=<?=$rec->id?>"><?=h($rec->name)?></a></td>
                <td><?=h($rec->city)?></td>
                <td><?=h($rec->country)?></td>
                <td><?=h($rec->address)?></td>
                <td>
                    <a href="https://www.google.com/maps/search/?api=1&query=<?=urlencode($rec->name . ', ' . $rec->city . ', ' . $rec->country)?>" target="_blank">Locate</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php
    $base_url = "?action=international_school_search";
    if ($search !== '') {
        $base_url .= "&search=" . urlencode($search);
    }
    paginate($total, $per_page, $page, $base_url);
    ?>
<?php endif; ?>
