<?php
// public_school_search.php
////require 'rb.php';

// --- CONFIGURATION ---
////$db_file = 'mwalimu.db'; // Adjust path as needed
$per_page = 20;

// --- INITIALIZE REDBEAN ---
////R::setup('sqlite:' . $db_file);

// --- GET PARAMETERS ---
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

// --- BUILD QUERY ---
$offset = ($page - 1) * $per_page;

if ($search !== '') {
    // Count total for pagination with search
    $total = R::count('public_school', 
        'name LIKE ? OR county LIKE ? OR constituency LIKE ?', 
        ["%$search%", "%$search%", "%$search%"]);
    
    // Fetch schools with search
    $schools = R::find('public_school', 
        'name LIKE ? OR county LIKE ? OR constituency LIKE ? ORDER BY name LIMIT ? OFFSET ?', 
        ["%$search%", "%$search%", "%$search%", $per_page, $offset]);
} else {
    // Count total for pagination without search
    $total = R::count('public_school');
    
    // Fetch schools without search
    $schools = R::find('public_school', 'ORDER BY name LIMIT ? OFFSET ?', 
        [$per_page, $offset]);
}

$total_pages = max(1, ceil($total / $per_page));
?>

<!DOCTYPE html>
<html>
<head>
    <title>Search Public Schools</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 2em; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ccc; padding: 8px; }
        th { background: #f8f8f8; }
        .pagination { margin: 1em 0; }
        .pagination a, .pagination span { margin: 0 2px; padding: 4px 8px; text-decoration: none; }
        .pagination .current { font-weight: bold; background: #ddd; }
        form { margin-bottom: 1em; }
    </style>
</head>
<body>
    <h2>Search Public Schools</h2>
    <form method="get" action="public_school_search.php">
        <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Search by name, county, or constituency">
        <button type="submit">Search</button>
    </form>

    <p>Showing <?= count($schools) ?> of <?= $total ?> schools<?= $search ? " for <b>".htmlspecialchars($search)."</b>" : "" ?>.</p>

    <table>
        <tr>
            <th>Name</th>
            <th>Level</th>
            <th>Status</th>
            <th>County</th>
            <th>Constituency</th>
            <th>Ward</th>
            <th>Code</th>
        </tr>
        <?php foreach ($schools as $school): ?>
        <tr>
            <td>
                <a href="public_school_detail.php?id=<?= urlencode($school->id) ?>">
                    <?= htmlspecialchars($school->name) ?>
                </a>
            </td>
            <td><?= htmlspecialchars($school->level) ?></td>
            <td><?= htmlspecialchars($school->status) ?></td>
            <td><?= htmlspecialchars($school->county) ?></td>
            <td><?= htmlspecialchars($school->constituency) ?></td>
            <td><?= htmlspecialchars($school->ward ?? '') ?></td>
            <td><?= htmlspecialchars($school->code ?? '') ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <div class="pagination">
        <?php if ($page > 1): ?>
            <a href="?search=<?= urlencode($search) ?>&page=<?= $page-1 ?>">&laquo; Prev</a>
        <?php endif; ?>
        <?php for ($p = 1; $p <= $total_pages; $p++): ?>
            <?php if ($p == $page): ?>
                <span class="current"><?= $p ?></span>
            <?php elseif ($p == 1 || $p == $total_pages || abs($p - $page) <= 2): ?>
                <a href="?search=<?= urlencode($search) ?>&page=<?= $p ?>"><?= $p ?></a>
            <?php elseif ($p == $page - 3 || $p == $page + 3): ?>
                ...
            <?php endif; ?>
        <?php endfor; ?>
        <?php if ($page < $total_pages): ?>
            <a href="?search=<?= urlencode($search) ?>&page=<?= $page+1 ?>">Next &raquo;</a>
        <?php endif; ?>
    </div>
</body>
</html>
<?php
// Close the database connection
R::close();
?>
