<?php
// public_school_search.php (partial for embedding in master layout)

// --- CONFIGURATION ---
$per_page = 20;

// --- GET PARAMETERS ---
$page = max(1, intval($_GET['page'] ?? 1));
$search = trim($_GET['search'] ?? '');

// --- BUILD QUERY ---
$offset = ($page - 1) * $per_page;

if ($search !== '') {
    // Count total for pagination with search
    $total = R::count('public_school',
        'name LIKE ? OR county LIKE ? OR constituency LIKE ?',
        ["%$search%", "%$search%", "%$search%"]);

    // Fetch schools with search
    $schools = R::find('public_school',
        'name LIKE ? OR county LIKE ? OR constituency LIKE ? ORDER BY name LIMIT ? OFFSET ?',
        ["%$search%", "%$search%", "%$search%", $per_page, $offset]);
} else {
    // Count total for pagination without search
    $total = R::count('public_school');

    // Fetch schools without search
    $schools = R::find('public_school', 'ORDER BY name LIMIT ? OFFSET ?', [$per_page, $offset]);
}

$total_pages = max(1, ceil($total / $per_page));
?>

<h2>Search Public Schools</h2>
<form method="get" action="index.php?action=public_school_search">
    <input type="hidden" name="action" value="public_school_search">
    <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" placeholder="Search by name, county, or constituency">
    <button type="submit">Search</button>
</form>

<p>Showing <?= count($schools) ?> of <?= $total ?> schools<?= $search ? " for <b>".htmlspecialchars($search)."</b>" : "" ?>.</p>
<style>
    th {
    font-weight: bold;
}
</style>

<table>
    <tr style="font-weight:bold;">
        <th>Name</th>
        <th>Level</th>
        <th>Status</th>
        <th>County</th>
        <th>Constituency</th>
        <th>Province</th>
        <th>District</th>
        <th>Division</th>
        <th>Location</th>
        <th>Email</th>
        <th>Latitude</th>
        <th>Longitude</th>
    </tr>
    <?php foreach ($schools as $school): ?>
    <tr>
        <td>
            <a href="?action=public_school_detail&id=<?= urlencode($school->id) ?>">
                <?= htmlspecialchars($school->name) ?>
            </a>
        </td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->level))) ?> </td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->status))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->county))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->constituency))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->province))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->district))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->division))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->location))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->email))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->latitude))) ?></td>
        <td><?= UCFirst(strtolower(htmlspecialchars($school->longitude))) ?></td>
    </tr>
    <?php endforeach; ?>
</table>

<div class="pagination">
    <?php if ($page > 1): ?>
        <a href="?action=public_school_detail&search=<?= urlencode($search) ?>&page=<?= $page-1 ?>">&laquo; Prev</a>
    <?php endif; ?>
    <?php for ($p = 1; $p <= $total_pages; $p++): ?>
        <?php if ($p == $page): ?>
            <span class="current"><?= $p ?></span>
        <?php elseif ($p == 1 || $p == $total_pages || abs($p - $page) <= 2): ?>
            <a href="?search=<?= urlencode($search) ?>&page=<?= $p ?>"><?= $p ?></a>
        <?php elseif ($p == $page - 3 || $p == $page + 3): ?>
            ...
        <?php endif; ?>
    <?php endfor; ?>
    <?php if ($page < $total_pages): ?>
        <a href="?action=public_school_detail&search=<?= urlencode($search) ?>&page=<?= $page+1 ?>">Next &raquo;</a>
    <?php endif; ?>
</div>
