<?php /* SCHOOL DIRECTORY PARTIAL - rb.php */ ?>
<article class="container">
    <?php
    // Database setup
    // require 'rb.php';
    // R::setup('sqlite:mwalimu.db');
    
    // Cookie-based authentication
    $is_admin = isset($_COOKIE['admin_auth']) && $_COOKIE['admin_auth'] === hash('sha256', 'Staff:Kenya@254');
    
    // Handle admin login
    if (isset($_POST['admin_login'])) {
        if ($_POST['username'] === 'Staff' && $_POST['password'] === 'Kenya@254') {
            setcookie('admin_auth', hash('sha256', 'Staff:Kenya@254'), time() + 3600, '/');
            header('Refresh:0');
            exit;
        } else {
            $login_error = "Invalid credentials!";
        }
    }
    
    // Handle CRUD operations
    if ($is_admin && isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_school':
                $school = R::dispense('school');
                $school->school_name = $_POST['school_name'];
                $school->school_email = $_POST['school_email'];
                R::store($school);
                break;
                
            case 'update_school':
                $school = R::load('school', (int)$_POST['school_id']);
                if ($school->id) {
                    $school->school_name = $_POST['school_name'];
                    $school->school_email = $_POST['school_email'];
                    R::store($school);
                }
                break;
                
            case 'delete_school':
                $school = R::load('school', (int)$_POST['school_id']);
                if ($school->id) R::trash($school);
                break;
        }
    }
    
    // Pagination and search
    $search = $_GET['search'] ?? '';
    $page = max(1, (int)($_GET['page'] ?? 1));
    $per_page = 10;
    
    $where = [];
    $params = [];
    if ($search) {
        $where[] = ' (school_name LIKE ? OR school_email LIKE ?) ';
        $params = array_fill(0, 2, "%$search%");
    }
    
    $where_sql = implode(' AND ', $where ?: [' 1 ']);

    // RedBean find() does not support LIMIT/OFFSET directly with params, so we use findAll() with SQL
    $sql = "ORDER BY school_name LIMIT ? OFFSET ?";
    $params_with_limit = array_merge($params, [$per_page, ($page - 1) * $per_page]);
    
    // Fetch schools with custom SQL
    $schools = R::findAll('school', $where_sql . ' ' . $sql, $params_with_limit);
    
    // Count total records
    $total = R::count('school', $where_sql, $params);
    $total_pages = ceil($total / $per_page);
    ?>
    
    <!-- Search Section -->
    <form class="grid" method="get" action="index.php">
        <input type="hidden" name="action" value="school_list">
        <div class="grid">
            <input type="search" name="search" placeholder="Search schools..." 
                   value="<?= htmlspecialchars($search) ?>">
            <button type="submit">Search</button>
        </div>
    </form>

    <!-- Schools Table -->
    <div class="table-responsive">
        <table role="grid">
            <thead>
                <tr>
                    <th>School Name</th>
                    <th>Email</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($schools as $school): ?>
                <tr>
                    <td><?= htmlspecialchars($school->school_name) ?></td>
                    <td>
                        <a href="mailto:<?= htmlspecialchars($school->school_email) ?>">
                            <?= htmlspecialchars($school->school_email) ?>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav class="grid">
        <?php if ($total_pages > 1): ?>
            <ul>
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li>
                        <a href="?page=<?= $i ?>&search=<?= urlencode($search) ?>" 
                           role="button" <?= $i == $page ? 'class="secondary"' : '' ?>>
                            <?= $i ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        <?php endif; ?>
    </nav>

    <!-- Admin Section -->
    <article class="card">
        <?php if (!$is_admin): ?>
            <form method="post">
                <fieldset>
                    <legend>Admin Login</legend>
                    <?php if (isset($login_error)): ?>
                        <div class="grid">
                            <small class="error"><?= $login_error ?></small>
                        </div>
                    <?php endif; ?>
                    <input type="text" name="username" placeholder="Username" required>
                    <input type="password" name="password" placeholder="Password" required>
                    <button type="submit" name="admin_login" class="contrast">Login</button>
                </fieldset>
            </form>
        <?php else: ?>
            <form method="post">
                <fieldset>
                    <legend>School Management</legend>
                    <input type="hidden" name="school_id" id="school_id">
                    <input type="text" name="school_name" id="school_name" placeholder="School Name" required>
                    <input type="email" name="school_email" id="school_email" placeholder="Email" required>
                    <div class="grid">
                        <button type="submit" name="action" value="add_school">Add School</button>
                        <button type="submit" name="action" value="update_school">Update School</button>
                        <button type="button" onclick="clearForm()" class="secondary">Cancel</button>
                    </div>
                </fieldset>
            </form>

            <!-- Admin School List -->
            <div class="table-responsive">
                <table>
                    <?php foreach ($schools as $school): ?>
                    <tr>
                        <td><?= htmlspecialchars($school->school_name) ?></td>
                        <td><?= htmlspecialchars($school->school_email) ?></td>
                        <td>
                            <button onclick="editSchool(<?= $school->id ?>, '<?= addslashes($school->school_name) ?>', '<?= addslashes($school->school_email) ?>')"
                                    class="secondary small">Edit</button>
                            <form method="post" style="display:inline">
                                <input type="hidden" name="school_id" value="<?= $school->id ?>">
                                <button type="submit" name="action" value="delete_school" 
                                        class="contrast small" 
                                        onclick="return confirm('Delete this school?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
    </article>

    <script>
        function editSchool(id, name, email) {
            document.getElementById('school_id').value = id;
            document.getElementById('school_name').value = name;
            document.getElementById('school_email').value = email;
            window.scrollTo({ top: document.querySelector('.card').offsetTop - 100, behavior: 'smooth' });
        }
        function clearForm() {
            document.getElementById('school_id').value = '';
            document.getElementById('school_name').value = '';
            document.getElementById('school_email').value = '';
        }
    </script>
</article>
