<?php
// school_list.php


// Pagination and search
$search = $_GET['search'] ?? '';
$page = max(1, (int)($_GET['page'] ?? 1));
$per_page = 10;

$where = [];
$params = [];
if ($search) {
    $where[] = ' (school_name LIKE ? OR school_email LIKE ?) ';
    $params = array_fill(0, 2, "%$search%");
}
$where_sql = implode(' AND ', $where ?: [' 1 ']);

// Fetch schools with custom SQL for pagination
$sql = "ORDER BY school_name LIMIT ? OFFSET ?";
$params_with_limit = array_merge($params, [$per_page, ($page - 1) * $per_page]);
$schools = R::findAll('school', $where_sql . ' ' . $sql, $params_with_limit);

// Count total records
$total = R::count('school', $where_sql, $params);
$total_pages = ceil($total / $per_page);
?>

<article class="container">

    <!-- Search Section -->
    <form class="grid" method="get" action="index.php">
        <input type="hidden" name="action" value="school_list">
        <div class="grid">
            <input type="search" name="search" placeholder="Search schools..." 
                   value="<?= htmlspecialchars($search) ?>">
            <button type="submit">Search</button>
        </div>
    </form>

    <!-- Schools Table -->
    <div class="table-responsive">
        <table role="grid" class="table striped">
            <thead>
                <tr>
                    <th>School Name</th>
                    <th>Email</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($schools as $school): ?>
                <tr>
                    <td><?= htmlspecialchars($school->school_name) ?></td>
                    <td>
                        <a href="mailto:<?= htmlspecialchars($school->school_email) ?>">
                            <?= htmlspecialchars($school->school_email) ?>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <nav class="grid">
        <?php if ($total_pages > 1): ?>
            <ul>
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li>
                        <a href="?action=school_list&page=<?= $i ?>&search=<?= urlencode($search) ?>" 
                           role="button" <?= $i == $page ? 'class="secondary"' : '' ?>>
                            <?= $i ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        <?php endif; ?>
    </nav>
<a href="?action=school_list_admin">admin</a>
</article>
