<?php
// School Login Section from dual_login.php

// Handle login form submission for schools
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login_type']) && $_POST['login_type'] === 'school') {
    try {
        // Check if email exists
        $school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if (!$school) {
            throw new Exception("School does not exist.");
        }

        // Check if password matches
        if (!password_verify($_POST['password'], $school->password)) {
            throw new Exception("Incorrect password.");
        }

        // Set cookie variables
        setcookie('school_id', $school->id, time() + (86400 * 30), "/"); // expires in 30 days
        setcookie('school_name', $school->name, time() + (86400 * 30), "/");

        // Redirect to school dashboard
        header('Location: ./index.php?action=school_dashboard');
        exit();
    } catch (Exception $e) {
        $school_error_message = $e->getMessage();
    }
}
?>

<article style="flex: 1; min-width: 300px; margin: 1rem;">
    <header>
        <h3>School Login</h3>
    </header>

    <?php if (isset($school_error_message)): ?>
    <div class="alert alert-error">
        <h4><?php echo htmlspecialchars($school_error_message); ?></h4>
    </div>
    <?php endif; ?>

    <form method="POST">
        <input type="hidden" name="login_type" value="school">
        <label for="email">Email</label>
        <input type="email" id="email" name="email" required>

        <label for="password">Password</label>
        <div class="password-input">
            <input type="password" placeholder="Password" id="password" name="password" required>
            <span class="password-toggle" onclick="togglePassword()">👁</span>
        </div>

        <button type="submit" class="primary">Login</button>
    </form>

    <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>

    <style>
    .password-input {
        position: relative;
        display: flex;
        align-items: center;
    }

    .password-input input[type="password"],
    .password-input input[type="text"] {
        padding-right: 30px;
        /* Space for the eye icon */
        width: 100%;
    }

    .password-toggle {
        position: absolute;
        right: 5px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        user-select: none;
    }
    </style>

    <script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
    }
    </script>
</article>
