<?php
// Start the session only if it's not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check if email exists
        $school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if (!$school) {
            throw new Exception("School does not exist.");
        }

        // Check if password matches
        if (!password_verify($_POST['password'], $school->password)) {
            throw new Exception("Incorrect password.");
        }

        // Set session variables
        $_SESSION['school_id'] = $school->id;
        $_SESSION['school_name'] = $school->name;

        // Redirect to school dashboard using PHP header
        header('Location: ./index.php?action=school_dashboard');
        exit();
    } catch (Exception $e) {
        $error_message = $e->getMessage();
    }
} elseif (!isset($_SESSION['school_id'])) {
    // If session variable is not set, show a message
    $error_message = "Session expired or invalid. Please log in again.";
}
?>

<!-- Linking to the locally stored pico.cyan.min.css file -->
<link rel="stylesheet" href="pico.cyan.min.css">

<div class="container">
    <h1>School Login</h1>

    <?php if (isset($error_message)): ?>
        <p style="color: red;"><?= htmlspecialchars($error_message) ?></p>
    <?php endif; ?>

    <form method="POST">
        <fieldset>
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>

            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Login</button>
        </fieldset>
    </form>

    <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>
</div>
