<?php
// views/school_login.php

// Start the session only if it's not already started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Initialize login attempts
if (!isset($_SESSION['login_attempts'])) {
    $_SESSION['login_attempts'] = 0;
}

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Check login attempts
        if ($_SESSION['login_attempts'] >= 5) {
            throw new Exception("Too many failed login attempts. Please try again after 15 minutes.");
        }

        // Check if email exists
        $school = R::findOne('school', 'email = ?', [$_POST['email']]);
        if (!$school) {
            $_SESSION['login_attempts']++;
            throw new Exception("No school account found with that email. Please ensure you have registered.");
        }

        // Check if password matches
        if (!password_verify($_POST['password'], $school->password)) {
            $_SESSION['login_attempts']++;
            throw new Exception("Invalid password. Please double-check your password.");
        }

        // Check account status
        if ($school->status !== 'active') {
            throw new Exception("Your account is not yet active. Please complete the subscription process or contact support.");
        }

        // Reset login attempts on successful login
        $_SESSION['login_attempts'] = 0;

        // Regenerate session ID for security
        session_regenerate_id(true);

        // Set session variables
        $_SESSION['school_id'] = $school->id;
        $_SESSION['school_name'] = $school->name;

        // Redirect to school dashboard using PHP header
        header('Location: ./index.php?action=school_dashboard');
        exit();
    } catch (Exception $e) {
        $error_message = $e->getMessage();
    }
} elseif (!isset($_SESSION['school_id'])) {
    // If session variable is not set, show a message
    $error_message = "Your session has expired or is invalid. Please log in again.";
}
?>

<!-- Linking to the locally stored pico.cyan.min.css file -->
<link rel="stylesheet" href="pico.cyan.min.css">

<div class="container">
    <h1>School Login</h1>

    <?php if (isset($error_message)): ?>
        <p style="color: red;"><?= htmlspecialchars($error_message) ?></p>
    <?php endif; ?>

    <form method="POST">
        <fieldset>
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>

            <label for="password">Password:</label>
            <input type="password" id="password" name="password" required>

            <button type="submit">Login</button>
        </fieldset>
    </form>

    <p>Don't have an account? <a href="index.php?action=school_register">Register here</a></p>
</div>
