<?php
// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Validate input data
        if (empty($_POST['name'])) {
            throw new Exception("School Name is required.");
        }
        if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
            throw new Exception("Invalid email address.");
        }
        if (!preg_match('/^2547[0-9]{8}$/', $_POST['phone_number'])) {
            throw new Exception("Invalid phone number format.");
        }
        if (strlen($_POST['password']) < 8) {
            throw new Exception("Password must be at least 8 characters long.");
        }
        if ($_POST['password'] !== $_POST['confirm_password']) {
            throw new Exception("Passwords do not match.");
        }

        // Store school details in the database
        $school = R::dispense('school');
        $school->name = htmlspecialchars($_POST['name']);
        $school->email = $_POST['email'];
        $school->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $school->phone_number = preg_replace('/[^0-9]/', '', $_POST['phone_number']);
        $school->address = htmlspecialchars($_POST['county']);
        $school->status = 'inactive';
        $school->subscription_expiry = null;

        // Save school to database
        $school_id = R::store($school);
        $school_name = $school->name;

        // Store session variables
        $_SESSION['school_id'] = $school_id;
        $_SESSION['school_name'] = $school_name;

        echo "<p>Registration successful!</p>";
        echo "<p>School Name: <strong>" . htmlspecialchars($school_name) . "</strong></p>";
        echo "<p>School ID: <strong>" . htmlspecialchars($_SESSION['school_id']) . "</strong></p>";
        echo "<p>School Name: <strong>" . htmlspecialchars($_SESSION['school_name']) . "</strong></p>";
        echo "<p>Redirecting to dashboard in 5 seconds...</p>";
        //echo '<meta http-equiv="refresh" content="5;url=./?action=school_dashboard&school_id="'.$school_id.'>';
        //**********header('Refresh: 5; url=./?action=school_dashboard');
        // JavaScript for redirect
echo '<script type="text/javascript">
        setTimeout(function(){
            window.location.href = "./index.php?action=school_dashboard";
        }, 5000); // Redirect after 5 seconds
      </script>';
        exit();
    } catch (Exception $e) {
        echo "<p>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
        echo "<p><a href='./?action=school_register'>Try Again</a> or <a href='./?action=landing'>Go Back to Home</a></p>";
        exit();
    }
}
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@picocss/pico@2/css/pico.cyan.min.css">

<div class="container">
    <h2>School Registration</h2>

    <form method="POST">
        <fieldset>
        <label for="name">School Name</label>
        <input type="text" id="name" name="name" required>

        <label for="email">Email</label>
        <input type="email" id="email" name="email" required>

        <label for="phone_number">Phone Number</label>
        <input type="tel" id="phone_number" name="phone_number" pattern="2547[0-9]{8}" required placeholder="2547xxxxxxxxx">

        <label for="county">County</label>
        <input type="text" id="county" name="county" required>

        <label for="password">Password</label>
        <input type="password" id="password" name="password" required>

        <label for="confirm_password">Confirm Password</label>
        <input type="password" id="confirm_password" name="confirm_password" required>
        </fieldset>
        <button type="submit">Register</button>
    </form>
</div>
