<?php
if (!isset($_COOKIE['school_id'])) {
    header('Location: index.php?action=school_login');
    exit();
}

// Pagination setup
$limit = 10; // Number of records per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Search filters
$country = isset($_GET['country']) ? $_GET['country'] : '';
$county = isset($_GET['county']) ? $_GET['county'] : '';
$subject = isset($_GET['subject']) ? $_GET['subject'] : '';
$experience = isset($_GET['experience']) ? (int)$_GET['experience'] : 0;
$grade = isset($_GET['grade']) ? $_GET['grade'] : '';

// Build query with filters
$query = "1=1"; // Default query condition
if (!empty($country)) $query .= " AND country LIKE '%$country%'";
if (!empty($county)) $query .= " AND county LIKE '%$county%'";
if (!empty($subject)) $query .= " AND teaching_subjects LIKE '%$subject%'";
if ($experience > 0) $query .= " AND years_of_experience >= $experience";
if (!empty($grade)) $query .= " AND grade_levels LIKE '%$grade%'";

// Fetch filtered results with pagination
$totalTeachers = R::count('teacher', $query);
$teachers = R::findAll('teacher', "$query LIMIT $limit OFFSET $offset");

// Calculate total pages
$totalPages = ceil($totalTeachers / $limit);
?>

<div class="w3-container w3-green">
    <h2>Search Candidates</h2>
</div>

<div class="w3-container">
    <form method="get" action="./index.php" class="w3-container w3-margin-bottom">
        <h3>Search Filters:</h3>
        <input type="hidden" name="action" value="school_search_candidate">
        <div class="w3-row-padding">
            <div class="w3-third">
                <label for="country">Country:</label>
                <input type="text" id="country" name="country" value="<?php echo htmlspecialchars($country); ?>" class="w3-input w3-border">
            </div>
            <div class="w3-third">
                <label for="county">County:</label>
                <input type="text" id="county" name="county" value="<?php echo htmlspecialchars($county); ?>" class="w3-input w3-border">
            </div>
            <div class="w3-third">
                <label for="subject">Subject:</label>
                <input type="text" id="subject" name="subject" value="<?php echo htmlspecialchars($subject); ?>" class="w3-input w3-border">
            </div>
        </div>
        <div class="w3-row-padding">
            <div class="w3-half">
                <label for="experience">Minimum Experience (Years):</label>
                <input type="number" id="experience" name="experience" value="<?php echo htmlspecialchars($experience); ?>" class="w3-input w3-border">
            </div>
            <div class="w3-half">
                <label for="grade">Grade:</label>
                <input type="text" id="grade" name="grade" value="<?php echo htmlspecialchars($grade); ?>" class="w3-input w3-border">
            </div>
        </div>
        <button type="submit" class="w3-button w3-green w3-margin-top">Search</button>
    </form>

    <h3>Available Teachers:</h3>

    <?php if (empty($teachers)): ?>
        <p>No teachers found.</p>
    <?php else: ?>
        <ul class="w3-ul">
            <?php foreach ($teachers as $teacher): ?>
                <li>
                    <strong><?php echo htmlspecialchars($teacher->name); ?></strong> -
                    <?php echo htmlspecialchars($teacher->teaching_subjects); ?> -
                    <?php echo htmlspecialchars($teacher->years_of_experience); ?> years experience -
                    <?php echo htmlspecialchars($teacher->grade_levels); ?> -
                    <a href="?action=teacher_profile&id=<?php echo $teacher->id; ?>">View Profile</a>
                </li>
            <?php endforeach; ?>
        </ul>

         <!-- Pagination Links -->
        <div class="w3-bar w3-center">
            <?php
            // Remove 'page' from query parameters to prevent duplication
            $queryParams = $_GET;
            unset($queryParams['page']);

            // Display "Page X of Y (Total Results)"
            echo "<p>Page $page of $totalPages (Total Results: $totalTeachers)</p>";

            // First Page Link
            if ($page > 1) {
                echo "<a href='?page=1&" . http_build_query($queryParams) . "' class='w3-button w3-light-grey'><i class='fa fa-angle-double-left'></i> First</a>";
            }

            // Previous Page Link
            if ($page > 1) {
                $prevPage = $page - 1;
                echo "<a href='?page=$prevPage&" . http_build_query($queryParams) . "' class='w3-button w3-light-grey'><i class='fa fa-angle-left'></i> Previous</a>";
            }

            // Current Page Display
            echo "<span class='w3-button w3-green'>Page $page</span>";

            // Next Page Link
            if ($page < $totalPages) {
                $nextPage = $page + 1;
                echo "<a href='?page=$nextPage&" . http_build_query($queryParams) . "' class='w3-button w3-light-grey'>Next <i class='fa fa-angle-right'></i></a>";
            }

            // Last Page Link
            if ($page < $totalPages) {
                echo "<a href='?page=$totalPages&" . http_build_query($queryParams) . "' class='w3-button w3-light-grey'>Last <i class='fa fa-angle-double-right'></i></a>";
            }
            ?>
        </div>
    <?php endif; ?>
</div>

<?php
// Helper function to sanitize GET parameters
function sanitize_input($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}
?>
