<?php
// Check if the teacher is logged in via cookies
if (!isset($_COOKIE['teacher_id']) || !isset($_COOKIE['teacher_name'])) {
    header('Location: index.php?action=teacher_login');
    exit();
}

// Retrieve teacher details from cookies
$teacher_id = htmlspecialchars($_COOKIE['teacher_id']);
$teacher_name = htmlspecialchars($_COOKIE['teacher_name']);
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Teacher Dashboard</h2>
    </header>

    <div class="grid gap-2">
        <h3>Welcome, <?php echo $teacher_name; ?>!</h3>
       

        <!-- Display Teacher Information -->
        <h4>Your Information</h4>
        <p>Teacher ID: <?php echo $teacher_id; ?></p>
        <p>Name: <?php echo $teacher_name; ?></p>
    </div>

    <div class="grid gap-2">
        <button type="button" onclick="location.href='index.php?action=teacher_job_search'" style="width: 10rem; height: 10rem; display: flex; justify-content: center; align-items: center; background-color: #f7f7f2; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-search fa-3x"></i>
            <br>
            Search Job Postings
        </button>
        <button type="button" onclick="location.href='index.php?action=public_school_search'" style="width: 10rem; height: 10rem; display: flex; justify-content: center; align-items: center; background-color: #f7f7f2; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-school fa-3x"></i>
            <br>
            Free Public School Search
        </button>

        <button type="button" onclick="location.href='index.php?action=teacher_update&teacher_id=<?php echo urlencode($teacher_id); ?>'" style="width: 10rem; height: 10rem; display: flex; justify-content: center; align-items: center; background-color: #f7f7f2; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-edit fa-3x"></i>
            <br>
            Update My Profile
        </button>

        <button type="button" onclick="location.href='index.php?action=logout'" style="width: 10rem; height: 10rem; display: flex; justify-content: center; align-items: center; background-color: #cccccc; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-sign-out-alt fa-3x"></i>
            <br>
            Logout
        </button>
    </div>
</article>

<?php
// Handle logout functionality
if (isset($_GET['action']) && $_GET['action'] === 'logout') {
    // Clear cookies by setting them with an expiration time in the past
    setcookie('teacher_id', '', time() - 3600, '/');
    setcookie('teacher_name', '', time() - 3600, '/');

    // Redirect to the landing page
    header('Location: index.php?action=landing');
    exit();
}
?>
