<?php
// views/teacher_login.php

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//kesh clear all browser cookies and sessions start
/** ***************************************** */
// Start the session if not already started
// At the very top of teacher_login.php or school_login.php

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Start session if not started
    if (session_status() === PHP_SESSION_NONE) session_start();

    // Clear all session variables
    $_SESSION = [];

    // Destroy the session cookie if it exists
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }

    // Destroy the session
    session_destroy();

    // Clear all cookies set by your application (adjust as needed)
    if (!empty($_COOKIE)) {
        foreach ($_COOKIE as $name => $value) {
            setcookie($name, '', time() - 3600, '/');
        }
    }
}

// After this, your login form and POST handler can safely start a new session and set session variables.

/**if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Clear all session variables
$_SESSION = [];

// Destroy the session cookie if it exists
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Clear all cookies set by your application (adjust cookie names as needed)
if (!empty($_COOKIE)) {
    foreach ($_COOKIE as $name => $value) {
        // To delete a cookie, set its expiration time in the past
        setcookie($name, '', time() - 3600, '/');
    }
}
*/

//kesh clear all browser cookies and sessions stop
/** ***************************************** */

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $teacher = R::findOne('teacher', ' email = ?', [$email]);

    if ($teacher && password_verify($password, $teacher->password)) {
        // Set cookie variables
        setcookie('teacher_id', $teacher->id, time() + (86400 * 30), "/"); // Valid for 30 days
        setcookie('teacher_name', $teacher->name, time() + (86400 * 30), "/"); // Valid for 30 days

        // Redirect to teacher dashboard
        header('Location: index.php?action=teacher_dashboard');
        exit();
    } else {
        $error_message = "Invalid email or password.";
    }
}
?>

<article class="card" style="max-width: 80%; margin: 2rem auto;">
    <header>
        <h2 style="text-align: center;">Teacher Login</h2>
    </header>

    <?php if (isset($error_message)): ?>
    <div class="alert alert-error">
        <h4><?php echo htmlspecialchars($error_message); ?></h4>
    </div>
    <?php endif; ?>

    <form method="POST" style="padding: 1rem;">
        <label for="email">Email:</label>
        <input type="email" name="email" id="email" required>

        <label for="password">Password:</label>
        <div class="password-input">
            <input type="password" name="password" id="password" required>
            <span class="password-toggle" onclick="togglePassword()">👁</span>
        </div>

        <button type="submit" class="primary" style="width: 100%;">Login</button>
    </form>

    <p>Don't have an account? <a href="index.php?action=teacher_register">Register here</a></p>

    <style>
    .password-input {
        position: relative;
        display: flex;
        align-items: center;
    }

    .password-input input[type="password"],
    .password-input input[type="text"] {
        padding-right: 30px;
        /* Space for the eye icon */
        width: 100%;
    }

    .password-toggle {
        position: absolute;
        right: 5px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        user-select: none;
    }
    </style>

    <script>
    function togglePassword() {
        const passwordInput = document.getElementById('password');
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
    }
    </script>
</article>
