<?php
// Check if the teacher ID is provided in the query parameters
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Load the teacher from the database
$teacher = R::load('teacher', $id);

// If the teacher is not found, display an error message and exit
if (!$teacher->id) {
    echo '<article><div class="alert alert-error">Teacher not found.</div></article>';
    exit();
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Teacher Profile: <?php echo htmlspecialchars($teacher->name); ?></h2>
    </header>

    <div style="padding: 1rem;">
        <h3>Personal Details</h3>
        <p><strong>Name:</strong> <?php echo htmlspecialchars($teacher->name); ?></p>
        <p><strong>Email:</strong> <a href="mailto:<?php echo htmlspecialchars($teacher->email); ?>"><?php echo htmlspecialchars($teacher->email); ?></a></p>
        <p><strong>Gender:</strong> <?php echo htmlspecialchars($teacher->gender); ?></p>
        <p><strong>Age:</strong> <?php echo htmlspecialchars($teacher->age); ?></p>
        <p><strong>Mobile:</strong> <?php echo htmlspecialchars($teacher->mobile); ?></p>
        <p><strong>Date of Birth:</strong> <?php echo htmlspecialchars($teacher->date_of_birth); ?></p>

        <h3>Professional Details</h3>
        <p><strong>Grade Level:</strong> <?php echo htmlspecialchars($teacher->grade_level); ?></p>
        <p><strong>Teaching Subject:</strong> <?php echo htmlspecialchars($teacher->teaching_subject); ?></p>
        <p><strong>Institution Attended:</strong> <?php echo htmlspecialchars($teacher->institutions_attended); ?></p>
        <p><strong>Years of Experience:</strong> <?php echo htmlspecialchars($teacher->years_of_experience); ?> years</p>
        <p><strong>Qualification:</strong> <?php echo htmlspecialchars($teacher->qualification); ?></p>

        <h3>Location & Credentials</h3>
        <p><strong>County:</strong> <?php echo htmlspecialchars($teacher->county); ?></p>
        <p><strong>Country:</strong> <?php echo htmlspecialchars($teacher->country); ?></p>
        <p><strong>TSC Number:</strong> <?php echo htmlspecialchars($teacher->tsc_number); ?></p>

        <h3>Brief Profile</h3>
        <p><?php echo htmlspecialchars($teacher->brief_profile); ?></p>

        <button type="button" onclick="location.href='mailto:<?php echo htmlspecialchars($teacher->email); ?>'" style="width: 10rem; height: 3rem; display: flex; justify-content: center; align-items: center; background-color: #f7f7f2; color: black; border: 1px solid #333; box-shadow: 0 0 10px rgba(128, 128, 128, 0.5);">
            <i class="fa fa-envelope fa-lg"></i>
            <span>Email Teacher</span>
        </button>
    </div>
</article>
