<?php
$message = '';
$showForm = true;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $teacher = R::dispense('teacher');

    $teacher->name = $_POST['name'] ?? '';
    $teacher->email = $_POST['email'] ?? '';
    $teacher->password = password_hash($_POST['password'] ?? '', PASSWORD_DEFAULT);
    $teacher->date_of_birth = $_POST['date_of_birth'] ?? '';
    $teacher->gender = $_POST['gender'] ?? '';
    $teacher->age = $_POST['age'] ?? '';
    $teacher->mobile = $_POST['mobile'] ?? '';
    $teacher->years_of_experience = $_POST['years_of_experience'] ?? '';
    $teacher->grade_levels = $_POST['grade_level'] ?? ''; // Corrected field name
    $teacher->teaching_subjects = $_POST['teaching_subject'] ?? ''; // Corrected field name
    $teacher->qualification = $_POST['qualification'] ?? '';
    $teacher->institutions_attended = $_POST['institutions_attended'] ?? '';
    $teacher->county = $_POST['county'] ?? '';
    $teacher->country = $_POST['country'] ?? '';
    $teacher->tsc_number = $_POST['tsc_number'] ?? '';
    $teacher->brief_profile = $_POST['brief_profile'] ?? '';
    $teacher->created_at = date('Y-m-d H:i:s');

    R::store($teacher);
    $message = '🎉 Registration successful!';
    $showForm = false;
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Register as a Teacher</h2>
    </header>

    <?php if ($message): ?>
        <div class="alert alert-success">
            <h4><?= htmlspecialchars($message) ?></h4>
        </div>
    <?php endif; ?>

    <?php if ($showForm): ?>
        <form method="post">
            <div class="grid">
                <input type="text" id="name" placeholder="Full Name" name="name" required>
            </div>

            <div class="grid">
                <input type="email" id="email" placeholder="Email" name="email" required>
            </div>

            <div class="grid">
                <input type="password" id="password" placeholder="Password" name="password" required>
                <small><a href="#" onclick="togglePassword(event)">👁 Show Password</a></small>
            </div>

            <div class="grid">
                <input type="date" id="date_of_birth" placeholder="Date of Birth" name="date_of_birth" required>
            </div>

            <div class="grid">
                <select id="gender" name="gender" required>
                    <option value="">-- Select Gender --</option>
                    <option>Male</option>
                    <option>Female</option>
                    <option>Other</option>
                </select>
            </div>

            <div class="grid">
                <input type="number" id="age" placeholder="Age" name="age" required>
            </div>

            <div class="grid">
                <input type="tel" id="mobile" placeholder="Mobile" name="mobile" required>
            </div>

            <div class="grid">
                <input type="number" id="years_of_experience" placeholder="Years of Experience" name="years_of_experience" required>
            </div>

            <div class="grid">
                <input type="text" id="grade_level" placeholder="Grade Level" name="grade_level" required>
            </div>

            <div class="grid">
                <input type="text" id="teaching_subject" placeholder="Teaching Subject" name="teaching_subject" required>
            </div>

            <div class="grid">
                <select id="qualification" name="qualification" required>
                    <option value="">-- Select Qualification --</option>
                    <option>Diploma</option>
                    <option>Bachelor's Degree</option>
                    <option>Postgraduate Diploma</option>
                    <option>Masters</option>
                    <option>PhD</option>
                    <option>Other</option>
                </select>
            </div>

            <div class="grid">
                <input type="text" id="institutions_attended" placeholder="Institutions Attended" name="institutions_attended" required>
            </div>

            <div class="grid">
                <input type="text" id="county" placeholder="County" name="county" required>
            </div>

            <div class="grid">
                <select id="country" name="country" required>
                    <option value="Kenya" selected>Kenya</option>
                    <option value="Uganda">Uganda</option>
                    <option value="Tanzania">Tanzania</option>
                    <option value="Rwanda">Rwanda</option>
                    <option value="Burundi">Burundi</option>
                    <option value="South Sudan">South Sudan</option>
                </select>
            </div>

            <div class="grid">
                <input type="text" id="tsc_number" placeholder="TSC Number" name="tsc_number" required>
            </div>

            <div class="grid">
                <textarea id="brief_profile" placeholder="Brief Profile (max 100 words)" name="brief_profile" maxlength="1000" rows="5" required></textarea>
            </div>

            <button type="submit">Register</button>
        </form>
    <?php endif; ?>

    <script>
        function togglePassword(e) {
            e.preventDefault();
            const passwordInput = document.getElementById('password');
            const type = passwordInput.getAttribute('type');
            passwordInput.setAttribute('type', type === 'password' ? 'text' : 'password');
            e.target.textContent = type === 'password' ? '🙈 Hide Password' : '👁 Show Password';
        }
    </script>
</article>
