<?php
$message = '';
$showForm = true;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if email already exists
    $existing_teacher = R::findOne('teacher', 'email = ?', [$_POST['email']]);
    if ($existing_teacher) {
        $message = '⚠️ This email is already registered. <a href="index.php?action=reset_password&email=' . htmlspecialchars($_POST['email']) . '">Reset password?</a>';
        $showForm = false; // Prevent registration
    } else {
        $teacher = R::dispense('teacher');

        $teacher->name = $_POST['name'] ?? '';
        $teacher->gender = $_POST['gender'] ?? '';
        $teacher->year_of_birth = $_POST['year_of_birth'] ?? '';
        $teacher->mobile = $_POST['mobile'] ?? '';
        $teacher->email = $_POST['email'] ?? '';
        $teacher->password = password_hash($_POST['password'] ?? '', PASSWORD_DEFAULT);
        $teacher->tsc_number = $_POST['tsc_number'] ?? '';
        $teacher->years_of_experience = $_POST['years_of_experience'] ?? '';
        $teacher->grade_levels = $_POST['grade_levels'] ?? '';
        $teacher->teaching_subjects = $_POST['teaching_subjects'] ?? '';
        $teacher->qualification = $_POST['qualification'] ?? '';
        $teacher->institutions_attended = $_POST['institutions_attended'] ?? '';
        $teacher->county = $_POST['county'] ?? '';
        $teacher->country = $_POST['country'] ?? '';
        $teacher->brief_profile = $_POST['brief_profile'] ?? '';
        $teacher->created_at = date('Y-m-d H:i:s');

        R::store($teacher);
        $message = '🎉 Registration successful!';
        $showForm = false;
    }
}
?>

<article class="card" style="max-width: 60%; margin: 0 auto;">
    <header>
        <h2>Register as a Teacher</h2>
    </header>

    <?php if ($message): ?>
        <div class="alert alert-<?= ($showForm ? 'warning' : 'success') ?>">
            <h4><?= htmlspecialchars($message) ?></h4>
        </div>
    <?php endif; ?>

    <?php if ($showForm): ?>
        <form method="post">
            <div class="grid">
                <input type="text" id="name" placeholder="Full Name" name="name" required>
            </div>

            <div class="grid">
                <select id="gender" name="gender" required>
                    <option value="">-- Select Gender --</option>
                    <option>Male</option>
                    <option>Female</option>
                    <option>Other</option>
                </select>
            </div>

            <div class="grid">
                <input type="number" id="year_of_birth" placeholder="Year of Birth" name="year_of_birth" min="1900"
                    max="<?php echo date('Y'); ?>" required>
            </div>

            <div class="grid">
                <input type="tel" id="mobile" placeholder="Mobile" name="mobile" required>
            </div>

            <div class="grid">
                <input type="email" id="email" placeholder="Email" name="email" required>
            </div>

            <div class="grid">
                <div class="password-input">
                    <input type="password" id="password" placeholder="Password" name="password" required>
                    <span class="password-toggle" onclick="togglePassword()">👁</span>
                </div>
            </div>

            <div class="grid">
                <input type="text" id="tsc_number" placeholder="TSC Number" name="tsc_number" required>
            </div>

            <div class="grid">
                <input type="number" id="years_of_experience" placeholder="Years of Experience"
                    name="years_of_experience" required>
            </div>

            <div class="grid">
                <input type="text" id="grade_levels" placeholder="Grade Levels" name="grade_levels" required>
            </div>

            <div class="grid">
                <input type="text" id="teaching_subjects" placeholder="Teaching Subjects" name="teaching_subjects"
                    required>
            </div>

            <div class="grid">
                <select id="qualification" name="qualification" required>
                    <option value="">-- Select Qualification --</option>
                    <option>Diploma</option>
                    <option>Bachelor's Degree</option>
                    <option>Postgraduate Diploma</option>
                    <option>Masters</option>
                    <option>PhD</option>
                    <option>Other</option>
                </select>
            </div>

            <div class="grid">
                <input type="text" id="institutions_attended" placeholder="Institutions Attended"
                    name="institutions_attended" required>
            </div>

            <div class="grid">
                <input type="text" id="county" placeholder="County" name="county" required>
            </div>

            <div class="grid">
                <select id="country" name="country" required>
                    <option value="Kenya" selected>Kenya</option>
                    <option value="Uganda">Uganda</option>
                    <option value="Tanzania">Tanzania</option>
                    <option value="Rwanda">Rwanda</option>
                    <option value="Burundi">Burundi</option>
                    <option value="South Sudan">South Sudan</option>
                </select>
            </div>

            <div class="grid">
                <textarea id="brief_profile" placeholder="Brief Profile (max 100 words)" name="brief_profile"
                    maxlength="1000" rows="5" required></textarea>
            </div>

            <button type="submit">Register</button>
        </form>
    <?php endif; ?>

    <style>
        .password-input {
            position: relative;
            display: flex;
            align-items: center;
        }

        .password-input input[type="password"],
        .password-input input[type="text"] {
            padding-right: 30px;
            /* Space for the eye icon */
            width: 100%;
        }

        .password-toggle {
            position: absolute;
            right: 5px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            user-select: none;
        }
    </style>

    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
        }
    </script>
</article>
