<?php
// Check if the teacher is logged in
if (!isset($_COOKIE['teacher_id'])) {
    header("Location: index.php?action=teacher_login");
    exit();
}

// Get the teacher's ID from the cookie
$teacher_id = $_COOKIE['teacher_id'];

// Fetch the teacher's data from the database
$teacher = R::load('teacher', $teacher_id);

// If the teacher doesn't exist, handle the error
if (!$teacher->id) {
    echo "<div class='container'><article class='message -error'>Teacher not found.</article></div>";
    exit();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve and update the teacher's information
    $teacher->name = $_POST['name'] ?? $teacher->name;
    $teacher->date_of_birth = $_POST['date_of_birth'] ?? $teacher->date_of_birth;
    $teacher->gender = $_POST['gender'] ?? $teacher->gender;
    $teacher->age = $_POST['age'] ?? $teacher->age;
    $teacher->mobile = $_POST['mobile'] ?? $teacher->mobile;
    $teacher->years_of_experience = $_POST['years_of_experience'] ?? $teacher->years_of_experience;
    $teacher->grade_level = $_POST['grade_level'] ?? $teacher->grade_level;
    $teacher->teaching_subject = $_POST['teaching_subject'] ?? $teacher->teaching_subject;
    $teacher->qualification = $_POST['qualification'] ?? $teacher->qualification;
    $teacher->institutions_attended = $_POST['institutions_attended'] ?? $teacher->institutions_attended;
    $teacher->county = $_POST['county'] ?? $teacher->county;
    $teacher->country = $_POST['country'] ?? $teacher->country;
    $teacher->tsc_number = $_POST['tsc_number'] ?? $teacher->tsc_number;
    $teacher->brief_profile = $_POST['brief_profile'] ?? $teacher->brief_profile;

    // Handle password update (only if a new password is provided)
    if (!empty($_POST['password'])) {
        $teacher->password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    }

    // Save the updated teacher data
    R::store($teacher);

    echo "<div class='container'><article class='message -success'>Your profile has been updated.</div></article>";
}
?>

<article class="card" style="max-width: 80%; margin: 0 auto;">
    <header>
        <h2>Update Teacher Profile</h2>
    </header>

    <form method="POST" action="" style="padding: 1rem;">

        <label for="name">
            Full Name
            <input type="text" id="name" name="name"
                value="<?php echo htmlspecialchars($teacher->name ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="date_of_birth">
            Date of Birth
            <input type="date" id="date_of_birth" name="date_of_birth"
                value="<?php echo htmlspecialchars($teacher->date_of_birth ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="gender">
            Gender
            <input type="text" id="gender" name="gender"
                value="<?php echo htmlspecialchars($teacher->gender ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="age">
            Age
            <input type="number" id="age" name="age"
                value="<?php echo htmlspecialchars($teacher->age ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="mobile">
            Mobile
            <input type="tel" id="mobile" name="mobile"
                value="<?php echo htmlspecialchars($teacher->mobile ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="years_of_experience">
            Years of Experience
            <input type="number" id="years_of_experience" name="years_of_experience"
                value="<?php echo htmlspecialchars($teacher->years_of_experience ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="grade_level">
            Grade Level
            <input type="text" id="grade_level" name="grade_level"
                value="<?php echo htmlspecialchars($teacher->grade_level ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="teaching_subject">
            Teaching Subject
            <input type="text" id="teaching_subject" name="teaching_subject"
                value="<?php echo htmlspecialchars($teacher->teaching_subject ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="qualification">
            Qualification
            <input type="text" id="qualification" name="qualification"
                value="<?php echo htmlspecialchars($teacher->qualification ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="institutions_attended">
            Institution Attended
            <input type="text" id="institutions_attended" name="institutions_attended"
                value="<?php echo htmlspecialchars($teacher->institutions_attended ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="county">
            County
            <input type="text" id="county" name="county"
                value="<?php echo htmlspecialchars($teacher->county ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="country">
            Country
            <input type="text" id="country" name="country"
                value="<?php echo htmlspecialchars($teacher->country ?? '', ENT_QUOTES, 'UTF-8'); ?>" required>
        </label>

        <label for="tsc_number">
            TSC Number
            <input type="text" id="tsc_number" name="tsc_number"
                value="<?php echo htmlspecialchars($teacher->tsc_number ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                required>
        </label>

        <label for="brief_profile">
            Brief Profile (max 100 words)
            <textarea id="brief_profile" name="brief_profile" maxlength="1000" rows="5"
                required><?php echo htmlspecialchars($teacher->brief_profile ?? '', ENT_QUOTES, 'UTF-8'); ?></textarea>
        </label>

        <label for="password">
            Password (leave blank to keep current)
            <input type="password" id="password" name="password">
        </label>

        <button type="submit" class="primary">Update Profile</button>

    </form>
</article>
